<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
?>
	<h1>Ad-hoc Reports</h1>
		<div class="column">
			<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
				<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
					<?php echo $tabs;?>
				</ul>
				<div class="tab-content">
					<div id="submenu">
						<ul>
							<li>
								<a href="/reports/adhoc_reports/personal"><span id="personal_reports" class="<?php if($show_report == "personal"){ echo "current_menutitle"; } else { echo "menutitle";}?>">Personal Reports</span></a>
							</li>
							<li>
								<a href="/reports/adhoc_reports/shared"><span id="shared_reports" class="<?php if($show_report == "shared"){ echo "current_menutitle"; } else { echo "menutitle";}?>">Shared Reports</span></a>
							</li>
							<li>
								<a href="/reports/adhoc_reports/everyone"><span id="global_reports" class="<?php if($show_report == "everyone"){ echo "current_menutitle"; } else { echo "menutitle";}?>">Global Reports</span></a>
							</li>
						</ul>
					</div>
					<?php
					//No Reports were found
						if(sizeof($report_list) == 0){
					?>
					<div style='clear:both'></div>
					<div class='message'>No reports were found!</div>
					<?php							
						} else { 
					?>	
					<div style="clear:both"></div>
					<div id="submenu">
						<?php if($show_report == "personal" || $this->user->is_admin()){?>
						<?php echo form_open('/reports/adhoc_report_delete_multiple/'.$show_report,array('id'=>'reports_delete_multiple','style'=>'float:left')); ?>
							<input type="hidden" id="report_ids_delete" name="report_ids_delete">
							<input  id="report_id_delete_button" class="adhoc_button_disabled" disabled name="search_button" type="submit" value="Delete" onClick="return confirm('Do you really want to delete selected report(s)?');"></input>
						<?php echo form_close(); ?>
						<?php }?>
						<?php echo form_open('/reports/adhoc_report_export_to_pdf_multiple/'.$show_report,array('id'=>'reports_delete_multiple','style'=>'float:left')); ?>
							<input type="hidden" id="report_ids_pdf" name="report_ids_pdf">
								<input  id="export_pdf_button" class="adhoc_button_disabled" disabled name="search_button" type="submit" value="Export PDF"></input>
						<?php echo form_close(); ?>
							<?php echo form_open('/reports/adhoc_report_export_to_excel_multiple/'.$show_report,array('id'=>'reports_delete_multiple','style'=>'float:left')); ?>
							<input type="hidden" id="report_ids_excel" name="report_ids_excel">
							<input  id="export_excel_button" class="adhoc_button_disabled" disabled name="search_button" type="submit" value="Export Excel"></input>
						<?php echo form_close(); ?>
					</div>
					
					<table id="report_table" class="grid stripe" cellspacing="0" rules="all" border="1" id="grdMain" style="border-collapse:collapse;">
							<thead>
								<tr class="gridheader">
									<th class="" scope="col">
										<input id="select-all-adhoc" type="checkbox"  title="Select All" alt="Select All"/>
									</th>
									<th scope="col">Report Name</th>
									<th scope="col">Category</th>											
									<th scope="col">Last Modified</th>
									<th scope="col">Created by</th>
									<th scope="col">Time Period</th>										
									<th scope="col">Actions</th>
								</tr>
							</thead>
							<tbody>
							<?php
							//get_user_id to display delete option or not
							$session_id = $this->encrypt->decode($this->session->userdata('user_id'));
							$user_session_id = $this->usersmodel->get_user_id_from_org_id($session_id); 
							
							foreach($report_list as $report){ ?>
							<tr id="report_title_tr<?php echo $report->report_id; ?>" class="gridrow">
								<td align="center" width="20px"><input id="<?php echo $report->report_id;?>" onclick="return OptionsSelected(this)" type="checkbox" title="Select <?php echo $report->report_name; ?>" alt="Select <?php echo $report->report_name; ?>"></td>
								<td width="30%">
									<div id="report_name_div" class="word_break" style="width: 300px;"><a id="report_name_link_<?php echo $report->report_id?>" href='/reports/<?php echo $report->report_type;?>/<?php echo $report->report_id;?>' class="adhoc_report_name" alt="Report Name: <?php echo $report->report_name; ?> - <?php echo $report->report_description; ?>" title="Report Name: <?php echo $report->report_name; ?> - <?php echo $report->report_description; ?>"><?php if ($user_session_id == $report->report_created_by){?> <i class="fa fa-user"></i> <?php } else{?><i class="fa fa-users"></i> <?php }?><?php echo $report->report_name; ?></a>
									</div>
									<div class="adhoc_description word_break"><?php 
									//if description report longer than 50 characters shows the small description
									$total_count = mb_strlen($report->report_description); 
									if($total_count <= 51){
									echo $report->report_description; 
									} else {
									echo $report->small_description . '<a href="#" rel="popover" data-placement="top" data-content="'.$report->report_description.'" data-original-title="'.$report->report_name.'"> ...</a>'; 
									}
									?></div>
								</td>
								<td><?php if($report->report_type == "user_activity_summary"){ 
										  echo "User Summary";
										  } else if($report->report_type == "points_of_origin"){ 
											echo "Points of Origin";
										  } 
										  else if($report->report_type == "hisp") {
											echo "HISP";
										  } 
										  else {
										  echo ucfirst($report->report_type);
										  }
								    ?>
								</td>
								<td id="modified_time<?php echo $report->report_id;?>"><?php echo date('m/d/y h:i:s A',$report->report_created_time); ?></td>
								<td><?php
									//checking LDAP for First Name and Last name 
									$resultArray = $this->useractivitysummarymodel->get_ldap_request($report->username);
									//checking that LDAP Results are not null
									
									if (isset ($resultArray[0]['givenname'][0])){
										$userGivenname = $resultArray[0]['givenname'][0];
									}else{
										$userGivenname = "";
									}
									
									if (isset ($resultArray[0]['sn'][0])){
										$userSN = $resultArray[0]['sn'][0];
									}else{
										$userSN = "";
									}
									echo $userGivenname . " " . $userSN;
								?></td>
								<td> 
									<select name="time_period" id="time_period_<?php echo $report->report_id;?>"  onchange="update_time_period('<?php echo $report->report_id?>');">
									  <option value="">Existing Time Period</option>
									  <option value="seven_days">Last 7 Days</option>
									  <option value="thirty_days">Last 30 Days</option>
									  <option value="last_month">Last Calendar Month</option>
									</select>
								</td>
								<td width="180px">
									<?php echo form_open('/reports/'.$report->report_type.'/'.$report->report_id,array('id'=>'report_time_period', 'style'=>'float:left; margin-left:5px;')); ?>
										<input type="hidden" name="time_period_status" value="true">
										<input type="hidden" name="time_period"  id="new_time_period_detail_<?php echo $report->report_id; ?>" value="" />
										<div><input type="submit" class="adhoc_button" value="Run" title="Run Report:<?php echo $report->report_name; ?>" class="innerbutton"></div>
									<?php echo form_close(); ?>
									<span class="size">
									<div><a class="adhoc_button field" style="margin-top:25px;" href="#" alt="More options for <?php echo $report->report_name; ?>" title="More options for <?php echo $report->report_name; ?>"><span class="nowrap">More<font class="adhoc_more_arrow">&#62;</font></span></a></div>
									<ul class="list">
										<?php echo form_open('/reports/adhoc_export/'.$report->report_id.'/pdf',array('id'=>'report_time_period_pdf_'.$report->report_id, 'Name'=>'report_time_period_pdf')); ?>
										<?php if ($user_session_id != $report->report_created_by){ ?>
											<li><img src="/images/icons/page_white_copy.png" class="link" style="border : 0;" alt="Copy Report" title="Copy Report"> <a href="/reports/copy_adhoc_report/<?php echo $report->report_id;?>"');">Copy</a></li>
										<?php  } ?>
										   <?php
												$time_period_hidden = array(
												  'time_period_status'   => 'true',
												);
												echo form_hidden($time_period_hidden);
												echo '<input type="hidden" name="time_period" id="new_time_period_pdf_'.$report->report_id.'" value="">';
											?>
										   <li><img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF"> <a href="#" onclick="document.getElementById('report_time_period_pdf_<?php echo $report->report_id;?>').submit();">Export PDF</a></li>
										<?php echo form_close(); ?>	
										<?php echo form_open('/reports/adhoc_export/'.$report->report_id.'/excel',array('id'=>'report_time_period_excel_'.$report->report_id, 'Name'=>'report_time_period_excel')); ?>
											<?php
												$time_period_hidden= array(
												  'time_period_status'   => 'true',
												);
												echo form_hidden($time_period_hidden);
												echo '<input type="hidden" name="time_period" id="new_time_period_excel_'.$report->report_id.'" value="">';
											?>
											<li><img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel"> <a href="#" onclick="document.getElementById('report_time_period_excel_<?php echo $report->report_id;?>').submit();">Export Excel</a></li>
										<?php echo form_close(); ?>	
										<?php echo form_open('/reports/report_'.$report->report_type.'/'.$report->report_id,array('id'=>'report_time_period_print_'.$report->report_id, 'Name'=>'report_time_period_print')); ?>									
											<?php
												$time_period_hidden = array(
												  'time_period_status'   => 'true',
												);
												echo form_hidden($time_period_hidden);
												echo '<input type="hidden" name="time_period" id="new_time_period_print_'.$report->report_id.'" value="">';
												echo '<input type="hidden" name="print_page" id="print_page'.$report->report_id.'" value="1">';
											?>
											<li><img src="/images/icons/printer.png" class="link" style="border : 0;" alt="Print" title="Print"> <a href="#" onclick="document.getElementById('report_time_period_print_<?php echo $report->report_id;?>').submit();">Print</a></li>
										<?php echo form_close(); ?>	
										
										<?php echo form_open('/reports/adhoc_export/'.$report->report_id.'/print',array('id'=>'report_time_period_print_'.$report->report_id, 'Name'=>'report_time_period_print')); ?>									
											<?php
												$time_period_hidden = array(
												  'time_period_status'   => 'true',
												);
												echo form_hidden($time_period_hidden);
												echo '<input type="hidden" name="time_period" id="new_time_period_print_'.$report->report_id.'" value="">';
											?>
										<?php echo form_close(); ?>	
										
										<?php if ($user_session_id == $report->report_created_by || $this->user->is_admin()){ ?>
											<li><img src="/images/icons/shape_square_edit.png" class="link" style="border : 0;" alt="Edit Name" title="Edit Name"> <a href="#" id="edit<?PHP echo $report->report_id; ?>">Edit Name</a></li>
											<li><img src="/images/icons/delete.png" class="link" style="border : 0;" alt="Delete" title="Delete"> <a href="/reports/adhoc_export_delete/<?php echo $report->report_id;?>" onClick="return confirm('Do you really want to delete [<?php echo $report->report_name; ?>] report?');">Delete</a></li>
										<?php } ?>
										<?php if ($user_session_id == $report->report_created_by || $this->user->is_admin()){ ?>
											<script>
											  $(function() {
											    $( "#edit_report_dialog<?PHP echo $report->report_id; ?>" ).dialog({
													autoOpen: false,
												  	modal: true,
												   	height: 260,
												   	width: 460,
												});
												
												$( "#edit<?PHP echo $report->report_id; ?>" ).click(function() {
													$( "#edit_report_dialog<?PHP echo $report->report_id; ?>" ).dialog( "open" );
												});
											  });
											</script>
											<div id="edit_report_dialog<?PHP echo $report->report_id; ?>" title="Edit Name for Ad-hoc Report: <?php echo $report->report_name?>">
												<div style="margin-top:5px; margin-bottom:5px; font-size:12px;">
													<div id="error_message_div<?php echo $report->report_id;?>" class="message_error" style="display: none;"></div>
													<div>
													<?php 
														echo form_label('<b>Report Name: <span style="color:red">*</span></b>', 'report_name');
														$report_name_input = array(
												              'name'        => 'report_name_' . $report->report_id,
												              'id'          => 'report_name_' . $report->report_id,
												              'value'       => $report->report_name,
												              'maxlength'   => '50',
												              'size'        => '45',
												              'class'       => 'topspace',
															  'onkeyup'     => 'countCharInTextField(this.id, 50)',
												        );
														echo form_input($report_name_input);?>
													</div>
													<div id="char_num_report_name_<?php echo $report->report_id;?>" class="character_count"><?php echo 50 - strlen($report->report_name);?> characters left</div>
													
													<div class="center" style="margin-top:28px;">
														<input id="save_report_name_btn<?php echo $report->report_id;?>" class="blue-button" id="save_button" name="save_button" type="button" onclick="javascript:validateAdhocReportEditForm(<?php echo $report->report_id;?>, '<?php echo $report->report_name;?>');" value="Save"></input>
														<input class="blue-button" id="close_pop_up" name="close_pop_up" type="button" value="Cancel" onclick="javascript:closeDialog('edit_report_dialog<?php echo $report->report_id;?>');" style="width:90px;"></input>
													</div>
												</div>
											</div>
											<?php 
											if($show_report == "shared") { ?>
											<script>
											  $(function() {
											   
												$( "#dialog<?PHP echo $report->report_id; ?>" ).dialog({
													autoOpen: false,
												  	modal: true,
												   	height: 350,
												   	width: 460,
												});
											 
												$( "#opener<?PHP echo $report->report_id; ?>" ).click(function() {
													$( "#dialog<?PHP echo $report->report_id; ?>" ).dialog( "open" );
												});

											  });
											</script>
											
												<div id="dialog<?PHP echo $report->report_id; ?>" title="<?php echo $report->report_name;?>">
												  <div style="margin-top:5px; margin-bottom:5px; font-size:12px;">Report Shared with:</b></div>
													<table id="selected_entry_table" class="display" style="font-size:11px;">
													<tbody>
													<tr class="report_row">
														<th>User (s)</th><th width="50px;" class="displaylast">Actions</th>
													</tr>			  
													  <?php
													  $user_id_list = $this->adhocreportsmodel->shared_users_ids($report->report_id)->result();
													  foreach($user_id_list as $result) {
														echo "<tr id ='row_".$result->user_id."'><td>"; 
														//checking LDAP for First Name and Last name 
															$resultArray = $this->useractivitysummarymodel->get_ldap_request($result->username);
															//checking that LDAP Results are not null
															
															if (isset ($resultArray[0]['givenname'][0])){
																$userGivenname = $resultArray[0]['givenname'][0];
															}else{
																$userGivenname = "";
															}
															
															if (isset ($resultArray[0]['sn'][0])){
																$userSN = $resultArray[0]['sn'][0];
															}else{
																$userSN = "";
															}
															echo "<i style='color:#666666; font-size:15px' class='fa fa-user'></i> " . $userGivenname . " " . $userSN;
														echo "</td>";
														echo '<td align="center">';
														if ($user_session_id == $result->user_id){
																echo '<i style="color:#666666; font-size:15px" class="fa fa-lock" title = "You"></i>';
															} else {
																echo '<a id="remove"'.$result->user_id.'" href=# title="Remove User" onclick="shared_remove_user('.$result->user_id.','.$report->report_id.');return false;"><i style="color:#666666; font-size:15px" class="fa fa-trash-o"></i></a>';													
															}
														echo '</td></tr>';
													  }
													  ?>
													</tbody>
													</table>
												</div>
											<li><img src="/images/icons/group_key.png" class="link" style="border : 0;" alt="User Management" title="User Management"> <a href="#" id="opener<?PHP echo $report->report_id; ?>">User Management</a></li>
										<?php }
										} ?>
									</ul>
									<span/>
								</td>
							</tr>
							<?php } ?>
						</tbody>
					</table>
					<?php } ?>
				</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
<?php if (isset($show_download)){?>
<!-- Multiple Download Starts Here--> 
<script>
  $(function() {
    //Create Dialog
	$( "#download" ).dialog({
		modal:true,
		width:460
	});
	//Close Dialog
	$("#download").on('click', '#close_pop_up', function(){
		$(this).closest( "#download").dialog('close');
	});
  });

 // Starts of Multiple Download*/
(function ($) {

    var methods = {
        _download: function (options) {
            var triggerDelay = (options && options.delay) || 100;
            var cleaningDelay = (options && options.cleaningDelay) || 1000;

            this.each(function (index, item) {
                methods._createIFrame(item, index * triggerDelay, cleaningDelay);
            });
            return this;
        },

        _createIFrame: function (item, triggerDelay, cleaningDelay) {
            setTimeout(function () {
             
				var frame = $('<iframe style="display: none;" class="multi-download-frame"></iframe>');
             
				frame.attr('src', $(item).attr('href') || $(item).attr('src'));          
			   $(item).after(frame);
                setTimeout(function () { frame.remove(); }, cleaningDelay);
            }, triggerDelay);
        }
    };

    $.fn.multiDownload = function(options) {
        return methods._download.apply(this, arguments);
    };

})(jQuery);
// End of Multiple Download*/

 </script>		

<div id="download" title="Download Files...">
  To download a file please click on the name of the report or click on the 'Download All' button.
  <ul class="download_list">								
	  <?php
	  //Report Type icon
	  $export_dir = '/reports/adhoc_export';
	  if($export_type =="adhoc_export_pdf"){
		$export_image = '<img src="/images/icons/page_white_acrobat.png" class="link" style="border : 0;" alt="Export PDF" title="Export PDF">';
	  } else {
		$export_image = '<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" title="Export Excel">';
	  }
	  foreach ($reports_id as $id){
		  $adhoc_report_name = $this->adhocreportsmodel->get_report_name_by_id($id)->result();
		  echo '<li><a href="'.$export_dir.'/'.$id.'/'.str_replace('adhoc_export_','',$export_type).'" class="document">'.$export_image.' '. $adhoc_report_name[0]->report_name.'</a></li>';
	  }
	  ?>
	  </ul> 
	 <div style="text-align:center;">
		<a class="blue-button"  href="#" id="download_all">Download All</a>		
		<input class="blue-button" id="close_pop_up" name="close_pop_up"  value="Cancel" style="width:90px;"></input>
	  </div>
</div>
<!-- Multiple Download End Here-->  
<?php } ?> 	
<script>
$(document).ready(function() {
	initializeAdhocReportDatatable();
} );

//Check all Functionality 
$('#select-all-adhoc').click(function(event) {
        var $that = $(this);
        $(':checkbox').each(function() {
            this.checked = $that.is(':checked');
        });
		OptionsSelected();
    });
	
function OptionsSelected(me)
{
	enableAdhocReportFormMultipleButtons();
	
	var values = [],
    inputs = document.getElementsByTagName("input");

	for (var i = inputs.length -1 ; i>= 0; i--)
    if (inputs[i].type === "checkbox" && inputs[i].checked)
          if (inputs[i].id != 'select-all-adhoc'){
			values.push(inputs[i].id);
			}	

	var delete_reports = document.getElementById("report_ids_delete");
	var pdf_reports = document.getElementById("report_ids_pdf");
	var excel_reports = document.getElementById("report_ids_excel");
	
	pdf_reports.value = values;	
	<?php if($show_report == "personal" || $this->user->is_admin()){?>
		delete_reports.value = values;
	<?php } ?>
	excel_reports.value = values;	
}

$('#download_all').click(function (event) {   
	event.preventDefault();
    $('.document').multiDownload({ delay: 4000 });
    $('#download').dialog('close');
});

//Pop over functionality
var timeoutObj;
$('[rel=popover]').popover({
    offset: 10,
    trigger: 'manual',
    html: true,
    placement: 'bottom',
    template: '<div class="popover" onmouseover="clearTimeout(timeoutObj);$(this).mouseleave(function() {$(this).hide();});"><div class="arrow"></div><div class="popover-inner"><h3 class="popover-title"></h3><div class="popover-content"><p></p></div></div></div>'
}).mouseenter(function(e) {
    $(this).popover('show');
}).mouseleave(function(e) {
    var ref = $(this);
    timeoutObj = setTimeout(function(){
        ref.popover('hide');
    }, 50);
});
</script>	
</html>